.TH %k 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
%k - Jacobi's complete elliptic integral
.SH CALLING SEQUENCE
.nf
[K]=%k(m)
.fi
.SH PARAMETERS
.TP 10
m
: parameter of the elliptic integral \fV0<m<1\fR (\fVm\fR can be a vector)
.TP
K
: value of the elliptic integral from 0 to 1 on the real axis
.SH DESCRIPTION
Calculates Jacobi's complete elliptic integral
of the first kind : 
.IG
.nf
K = integral from 0 to 1 of [(1-t^2)(1-m*t^2)]**(-1/2)
.fi
.FI
.LA $$ K = \int_0^1 { dt \over [(1-t^2)(1-m t^2)]^{1/2}} $$
.SH EXAMPLE
.nf
m=0.4;
%asn(1,m)
%k(m)
.fi
.SH REFERENCES
Abramowitz and Stegun page 598
.SH SEE ALSO
%asn
.SH AUTHOR
F.D.
